(************** Content-type: application/mathematica **************

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     40579,       1274]*)
(*NotebookOutlinePosition[     41442,       1305]*)
(*  CellTagsIndexPosition[     41368,       1299]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    StyleBox[\(<< Graphics`ComplexMap`\),
      "Input"]], "Input"],

Cell[BoxData[
    StyleBox[\(CartesianMap[\((#^2)\) &, {1, 2,  .1}, {1, 2,  .1}, 
        PlotStyle -> {Green, Red}]\),
      "Input"]], "Input"],

Cell[BoxData[
    \(CartesianMap[\((1/#)\) &, { .1, 2,  .1}, { .1,  .11,  .01}, 
      PlotStyle -> {Green, Red}]\)], "Input"],

Cell[TextData[{
  "\n",
  StyleBox["Example 2.19,  Page 69.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  Consider the mapping  ",
  Cell[BoxData[
      \(w = \(f \((z)\) = 1\/z\)\)],
    AspectRatioFixed->True],
  ".   \n",
  StyleBox["(a)",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  Find the images of the vertical lines  x = a.   ",
  StyleBox["(b)",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  Find the images the horizontal lines  y = b."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Solution 2.19.",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]]], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  StyleBox["(a)",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  ",
  "First, find the images of the vertical lines  x = a."
}], "Text"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(Clear[a, ac, al, b, bc, bl, circlea, circleb, hc, 
        hl, horiz, x, y, u, v, vc, verti, vl, wplane, zplane];\)\), "\n", 
    \(\(Print[eq1\  = \ x\  \[Equal] \ a];\)\), "\n", 
    \(\(Print[
        eq2\  = \ 
          ReplaceAll[
            eq1\ , {x \[Rule] u\/\(u\^2\  + \ v\^2\), 
              y \[Rule] \(-v\)\/\(u\^2\  + \ v\^2\)}]];\)\), "\n", 
    \(\(Print[
        eq3\  = \ 
          Distribute[\ \((u\^2\  + \ v\^2)\)\/a\ \ eq2, \ 
            Equal]];\)\), "\n", 
    \(\(Print[
        eq4\  = \ Distribute[\ \(-\ u\)\/a\  + \ eq3, \ Equal]];\)\), "\n", 
    \(\(\(Print[
        eq5\  = \ 
          Distribute[\ 1\/\((2  a)\)\^2\  + \ eq4, \ 
            Equal]];\)\(\[IndentingNewLine]\)
    \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "\nThe image of the vertical lines  x = a  is the circle",
  Cell[BoxData[
      \(\(\(|\)\(w - 1\/\(2  a\)\)\(|\)\) = 1\/\(2 | a | \)\)]],
  ",  with center  ",
  Cell[BoxData[
      \(w\_0 = 1\/\(2  a\)\)]],
  "  and radius  ",
  Cell[BoxData[
      \(1\/\(2 | a | \)\)]],
  ".  \n\n",
  StyleBox["(b)",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  Second, find the images the horizontal lines  y = b."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\[IndentingNewLine]\(Print[eq1\  = \ y\  \[Equal] \ b];\)\), "\n", 
    \(\(Print[
        eq2\  = \ 
          ReplaceAll[
            eq1\ , {x \[Rule] u\/\(u\^2\  + \ v\^2\), 
              y \[Rule] \(-v\)\/\(u\^2\  + \ v\^2\)}]];\)\), "\n", 
    \(\(Print[
        eq3\  = \ 
          Distribute[\ \((u\^2\  + \ v\^2)\)\/b\ \ eq2, \ 
            Equal]];\)\), "\n", 
    \(\(Print[eq4\  = \ Distribute[\ v\/b\  + \ eq3, \ Equal]];\)\), "\n", 
    \(\(\(Print[
        eq5\  = \ 
          Distribute[\(\(\ \)\(1\)\)\/\((2  b)\)\^2\  + \ eq4, \ 
            Equal]];\)\(\[IndentingNewLine]\)
    \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "\nThe image is the circle",
  Cell[BoxData[
      \(\(\(|\)\(w + \[ImaginaryI]\/\(2  b\)\)\(|\)\) = 1\/\(2 | b | \)\)]],
  ",  with center  ",
  Cell[BoxData[
      \(w\_0 = \(-\ i\)\/\(2  b\)\)]],
  "  and radius  ",
  Cell[BoxData[
      \(1\/\(2 | b | \)\)]],
  ".  \n\nNow prepare some horizontal and vertical lines in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for graphing."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\[IndentingNewLine]\(hl[b_]\  = \ 
        Line[{{\(-2\), b}, {2, b}}];\)\), "\n", 
    \(\(horiz\  = \ {hl[\(-1\)], hl[\(-1\)\/2], hl[1\/2], hl[1]};\)\), "\n", 
    \(\(bl\  = \ Graphics[horiz];\)\), "\n", 
    \(\(vl[a_]\  = \ Line[{{a, \(-2\)}, {a, 2}}];\)\), "\n", 
    \(\(verti\  = \ {vl[\(-1\)], vl[\(-1\)\/2], vl[1\/2], vl[1]};\)\), "\n", 
    \(\(al\  = \ Graphics[verti];\)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "\nNow prepare the image circles in ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  " for graphing."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\[IndentingNewLine]\(hc[b_]\  = \ 
        Circle[{0, \(-1\)\/\(2  b\)}, 1\/Abs[2  b]];\)\), "\n", 
    \(\(circleb\  = \ {hc[\(-1\)], hc[\(-1\)\/2], hc[1\/2], 
          hc[1]};\)\), "\n", 
    \(\(bc\  = \ Graphics[circleb];\)\), "\n", 
    \(\(vc[a_]\  = \ Circle[{1\/\(2  a\), 0}, 1\/Abs[2  a]];\)\), "\n", 
    \(\(circlea\  = \ {vc[\(-1\)], vc[\(-1\)\/2], vc[1\/2], 
          vc[1]};\)\), "\n", 
    \(\(ac\  = \ Graphics[circlea];\)\)}], "Input",
  AspectRatioFixed->True],

Cell["\<\

Graph the horizontal and vertical lines and their images.\
\>", "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\[IndentingNewLine]\(Show[al, bl, 
        PlotRange \[Rule] {{\(-2.2\), 2.2}, {\(-2.2\), 
              2.2}}, \[IndentingNewLine]AspectRatio \[Rule] 1, 
        Axes \[Rule] 
          True, \[IndentingNewLine]Ticks \[Rule] {Range[\(-4\), 4, 1], 
            Range[\(-4\), 4, 
              1]}, \[IndentingNewLine]AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
        DefaultColor \[Rule] Blue];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<The vertical  lines  x = a,\>"];\)\), "\[IndentingNewLine]", \

    \(\(Print["\<and horizontal lines y = b.\>"];\)\), "\n", 
    \(\(Show[ac, bc, 
        PlotRange \[Rule] {{\(-2.2\), 2.2}, {\(-2.2\), 
              2.2}}, \[IndentingNewLine]AspectRatio \[Rule] 1, 
        Axes \[Rule] 
          True, \[IndentingNewLine]Ticks \[Rule] {Range[\(-4\), 4, 1], 
            Range[\(-4\), 4, 
              1]}, \[IndentingNewLine]AxesLabel \[Rule] {"\<u\>", "\<v\>"}, 
        DefaultColor \[Rule] Blue];\)\), "\n", 
    \(\(Print["\<The image circles |w-\!\(1\/\"2a\"\)| = \
\!\(1\/\"2|a|\"\),\>"];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<and  |w+\!\(\[ImaginaryI]\/\"2b\"\)| = \
\!\(1\/\"2|b|\"\),\>"];\)\), "\n", 
    \(\(\(Print[\*"\"\<under the mapping  w = \!\(1\/z\).\>\""];\)\(\
\[IndentingNewLine]\)
    \)\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "\nWe see that the images of the vertical lines  x = a  and  horizontal \
lines  y = b  under the mapping  ",
  Cell[BoxData[
      \(w = 1\/z\)],
    AspectRatioFixed->True],
  " are circles."
}], "Text"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(Clear[f, Iden, W, z, Z];\)\), "\n", 
    \(\(Iden[z_] = z;\)\), "\n", 
    \(\(f[z_] = 1\/z;\)\), "\n", 
    \(\(Z[z_] = Iden[z + 1\/2];\)\), "\n", 
    \(\(W[z_] = f[z + 1\/2];\)\), "\n", 
    \(\(zplane\  = \ 
        PolarMap[
          Z\ , {0, 1, 
            0.1}, {\(-\[Pi]\)\/2, \[Pi]\/2, \[Pi]\/12}, \
\[IndentingNewLine]PlotRange \[Rule] {{\(-0.1\), 2.1}, {\(-1.1\), 1.1}}, 
          AspectRatio \[Rule] 1, 
          Ticks \[Rule] {Range[\(-6\), 4, 1], Range[\(-2\), 8, 1]}, 
          AxesLabel \[Rule] {"\<x\>", "\<y\>"}, 
          PlotStyle \[Rule] {Red, Magenta}];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<The portion of the half-plane Re[z] > \!\(1\/2\),\>\""];\
\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<that lies inside the circle |z-\!\(1\/2\)| < 1.\>\""];\)\
\), "\n", 
    \(\(wplane\  = \ 
        PolarMap[
          W\ , {0, 1, 
            0.1}, {\(-\[Pi]\)\/2, \[Pi]\/2, \[Pi]\/12}, \
\[IndentingNewLine]PlotRange \[Rule] {{\(-0.1\), 2.1}, {\(-1.1\), 1.1}}, 
          AspectRatio \[Rule] 1, 
          Ticks \[Rule] {Range[0, 2, 1], Range[\(-1\), 1, 1]}, 
          AxesLabel \[Rule] {"\<u\>", "\<v\>"}, 
          PlotStyle \[Rule] {Red, Magenta}];\)\), "\n", 
    \(\(Print["\<The image is the part of the disk |w-1|<1,\>"];\)\), "\
\[IndentingNewLine]", 
    \(\(Print[\*"\"\<that lies outside the circle |w+\!\(2\/3\)| = \
\!\(4\/3\),\>\""];\)\), "\n", 
    \(\(\(Print["\<under the mapping  w = \>", 
        f[z]];\)\(\[IndentingNewLine]\)
    \)\)}], "Input",
  AspectRatioFixed->True],

Cell[BoxData[
    StyleBox[\(\(RootPlot[poly_, \ z]\  := \ 
        ListPlot[{Re[z], \ Im[z]}\  /. \ NSolve[\ poly\  == \ 0, \ z], \ 
          AspectRatio\  -> \ Automatic\ , 
          PlotStyle -> PointSize[0.02]]\)\(\ \)\(\n\)
      \),
      FormatType->StandardForm]], "Input"],

Cell[BoxData[
    \(\(RootPlot[z^8 + 5  z^2 + 4  z^3 - 2, z];\)\)], "Input"],

Cell[BoxData[
    \(Solve[x\^6 == 1, 
        x] /. \((a_ -> b_)\) :> \((a -> ComplexExpand[b])\)\)], "Input"],

Cell[BoxData[
    RowBox[{
      StyleBox["ComplexExpand",
        "MR"], 
      StyleBox["[",
        "MR"], 
      RowBox[{
        StyleBox["expr",
          "TI"], 
        StyleBox[",",
          "MR"], " ", 
        StyleBox["vars",
          "TI"], 
        StyleBox[",",
          "MR"], " ", 
        RowBox[{
          StyleBox["TargetFunctions",
            "MR"], " ", "\[Rule]", " ", 
          RowBox[{
            FormBox["{",
              "TraditionalForm"], 
            RowBox[{
              StyleBox["Abs",
                "MR"], 
              StyleBox[",",
                "MR"], " ", 
              StyleBox["Arg",
                "MR"]}], 
            FormBox["}",
              "TraditionalForm"]}]}]}], 
      StyleBox["]",
        "MR"]}]], "Input"],

Cell[BoxData[
    \(soluciones = Solve[z^8 \[Equal] 1, z]\)], "Input"],

Cell[BoxData[
    \(soluciones = 
      Solve[z^8 \[Equal] 1, 
          z] /. \((a_ \[Rule] b_)\) \[RuleDelayed] \((a \[Rule] 
              ComplexExpand[b])\)\)], "Input"],

Cell[BoxData[
    \(soluciones = 
      Solve[z^8 \[Equal] 1, 
          z] /. \((a_ \[Rule] b_)\) \[RuleDelayed] \((a \[Rule] 
              polarform[b])\)\)], "Input"],

Cell[BoxData[
    \(polarform[z_] := Abs[z] Exp[\[ImaginaryI]\ Arg[z]]\)], "Input"],

Cell[BoxData[
    \(poligono[r_, n_, ang_] := 
      Table[{r\ Cos[2  Pi\ k/n + ang], \ r\ Sin[2  Pi\ k/n + ang]}, {k, 0, 
          n - 1}]\)], "Input"],

Cell[BoxData[
    \(\(penta = poligono[1, 5, Pi/4];\)\)], "Input"],

Cell[BoxData[
    \(\(ListPlot[penta, AspectRatio \[Rule] Automatic, 
        PlotStyle \[Rule] PointSize[0.02], Ticks \[Rule] None];\)\)], "Input"],

Cell[BoxData[
    \(\(Show[
        Graphics[Line[Append[penta, penta[\([1]\)]]], 
          AspectRatio \[Rule] Automatic, 
          Background \[Rule] GrayLevel[0.9]]];\)\)], "Input"],

Cell[BoxData[
    \(\(animapoly[n_] := 
        Table[Show[
            Graphics[{RGBColor[1, 0, 0], 
                Line[Append[
                    poligono[1, n, k], \(poligono[1, n, k]\)[\([1]\)]]], 
                RGBColor[0, 0, 1], Circle[{0, 0}, 1]}, 
              AspectRatio \[Rule] Automatic]], {k, 0, N[2  \[Pi]], 
            N[\[Pi]/n]}];\)\)], "Input"],

Cell[BoxData[
    \(\(animapoly[5];\)\)], "Input"],

Cell[BoxData[
    \(\(animapolygono[p_, q_] := 
        Table[Show[
            Graphics[{RGBColor[1, 0, 0], 
                Line[Append[
                    poligono[1, k, 0], \(poligono[1, k, 0]\)[\([1]\)]]], 
                RGBColor[0, 0, 1], Circle[{0, 0}, 1]}, 
              AspectRatio \[Rule] Automatic]], {k, p, q}];\)\)], "Input"],

Cell[BoxData[
    \(\(animapolygono[5, 11];\)\)], "Input"],

Cell[TextData[{
  "\tAn impetus for studying complex analysis is the comparison of properties \
of real numbers and functions with their complex counterparts.  In this \
section we take a look at Newton's method for finding solutions to the \
equation  ",
  Cell[BoxData[
      \(f \((x)\) = 0\)]],
  ".  We then examine the more general topic of iteration.\n\n\tRecall from \
calculus that Newton's method proceeds by starting with a function  f(x)  and \
an initial \"guess\"  ",
  Cell[BoxData[
      \(x\_0\)]],
  "  as a solution to  ",
  Cell[BoxData[
      \(f \((x)\) = 0\)]],
  ".  We then generate a new guess  ",
  Cell[BoxData[
      \(x\_1\)]],
  "  by the computation  ",
  Cell[BoxData[
      \(x\_1 = x\_0 - \(f \((x\_0)\)\)\/\(f' \((x\_0)\)\)\)]],
  ".  Using  ",
  Cell[BoxData[
      \(x\_1\)]],
  " in place of  ",
  Cell[BoxData[
      \(x\_0\)]],
  ",  this process is repeated, giving us  ",
  Cell[BoxData[
      \(x\_2 = x\_1 - \(f \((x\_1)\)\)\/\(f' \((x\_1)\)\)\)]],
  ".  Thus we obtain a sequence of points  ",
  Cell[BoxData[
      \({x\_k}\)]],
  ", where  ",
  Cell[BoxData[
      \(x\_\(k + 1\) = x\_k - \(f \((x\_k)\)\)\/\(f' \((x\_k)\)\)\)]],
  ".  The points  ",
  Cell[BoxData[
      \({x\_k}\_\(k = 0\)\%\[Infinity]\)]],
  "  are called the ",
  StyleBox["iterates",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  " of  ",
  Cell[BoxData[
      \(x\_0\)]],
  ".  For functions defined on the real numbers, this method gives remarkably \
good results so that the sequence  ",
  Cell[BoxData[
      \({x\_k}\)]],
  "  often converges to a solution of  ",
  Cell[BoxData[
      \(f \((x)\) = 0\)]],
  "  rather quickly.  In the late 1800's the british mathematician Arthur \
Cayley investigated the question as to whether Newton's method can be applied \
to complex functions.  He wrote a paper giving an analysis for how this \
method works for quadratic polynomials and indicated his intention to publish \
a subsequent paper for cubic polynomials.  Unfortunately, Cayley died before \
producing this paper.  As you will see, The extension of Newton's method to \
the complex domain and the more general question of iteration are quite \
complicated."
}], "Text"],

Cell[TextData[{
  "Load ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "'s  \"Colors\"  package."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(Needs["\<Graphics`Colors`\>"];\)\)], "Input",
  InitializationCell->True,
  AspectRatioFixed->True],

Cell[TextData[{
  "\n",
  StyleBox["Example 4.20,  Page116.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  Trace out the next five iterates of Newton's method given an initial \
guess of  ",
  Cell[BoxData[
      \(z\_0 = 1\/4 + \[ImaginaryI]\/4\)]],
  "  as a solution to the equation  ",
  Cell[BoxData[
      \(f[z] = 0\)]],
  ",  where  ",
  Cell[BoxData[
      \(f[z] = z\^2 + 1\)]],
  ".  "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(listado = 
        NestList[\((# - \((1 + #^2)\)/\((2\ \ #)\))\) &, 
          1/4\  + \ \[ImaginaryI]/4, 12];\)\)], "Input"],

Cell[BoxData[
    \(\(\(TableForm[
      Transpose[{Table[k, {k, 0, 12}], N[listado], 
          Map[\((#^2\  + \ 1)\) &, N[listado]]}]]\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \(ListPlot[ReplaceAll[N[listado], Complex[xx_, yy_] \[Rule] {xx, yy}], 
      PlotRange \[Rule] {{\(-0.9\), 0.5}, {0.0, 1.2}}, 
      Prolog \[Rule] {PointSize[0.02], 
          Magenta}, \[IndentingNewLine]AspectRatio \[Rule] 1.2\/1.4, 
      AxesLabel \[Rule] {"\<x\>", "\<y\>"}, \[IndentingNewLine]Ticks \[Rule] \
{Range[\(-1\), 1, 0.2], Range[0, 1.2, 0.2]}]\)], "Input"],

Cell["\<\
El m\[EAcute]todo de Newton falla si partimos de una aproximaci\[OAcute]n \
inicial que sea real.\
\>", "Text"],

Cell[TextData[{
  "\n",
  StyleBox["Extra Example for Page118.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  Investigate Newton's method for finding the roots of  ",
  Cell[BoxData[
      \(f[z] = z\^3 + 1\)]],
  ".\nGiven the initial seed  ",
  Cell[BoxData[
      \(z\_0\)]],
  "  determine if the sequence  ",
  Cell[BoxData[
      \({z\_k}\)]],
  "  converges to one of the roots  ",
  Cell[BoxData[
      \(z = \(-1\), 1\/2 + \(\[ImaginaryI]\ \@3\)\/2, 
      1\/2 - \(\[ImaginaryI]\ \@3\)\/2\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Extra Solution for Page 118.",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]]], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Enter the function  ",
  Cell[BoxData[
      \(f[z] = z\^3 + 1\)]],
  "  and find its roots."
}], "Text"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(Remove[z, Z];\)\), "\[IndentingNewLine]", 
    \(\(Clear[f];\)\), "\[IndentingNewLine]", 
    \(\(f[z_] = z\^3 + 1;\)\), "\[IndentingNewLine]", 
    \(\(solset = Solve[f[z] \[Equal] 0, z];\)\), "\[IndentingNewLine]", 
    \(\(Z\_1 = 
        ComplexExpand[
          solset\_\(\(\[LeftDoubleBracket]\)\(1, 1, \
2\)\(\[RightDoubleBracket]\)\), 
          TargetFunctions \[Rule] {Im, Re}];\)\), "\[IndentingNewLine]", 
    \(\(Z\_2 = 
        ComplexExpand[
          solset\_\(\(\[LeftDoubleBracket]\)\(2, 1, \
2\)\(\[RightDoubleBracket]\)\), 
          TargetFunctions \[Rule] {Im, Re}];\)\), "\[IndentingNewLine]", 
    \(\(Z\_3 = 
        ComplexExpand[
          solset\_\(\(\[LeftDoubleBracket]\)\(3, 1, \
2\)\(\[RightDoubleBracket]\)\), 
          TargetFunctions \[Rule] {Im, Re}];\)\), "\[IndentingNewLine]", 
    \(Z\_4 = \ 
      z /. \((solset /. \((a_ \[Rule] b_)\) \[RuleDelayed] \ \((a \[Rule] 
                    ComplexExpand[
                      b])\))\)[\([2]\)]\), "\[IndentingNewLine]", 
    \(\(Print["\<f[z] = \>", f[z]];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<\>"];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<The roots are\>"];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<\!\(z\_1\) = \>\"", Z\_1];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<\!\(z\_2\) = \>\"", Z\_2];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<\!\(z\_3\) = \>\"", Z\_3];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<\!\(z\_4\) = \>\"", Z\_4];\)\), "\[IndentingNewLine]", 
    \(\)}], "Input"],

Cell[TextData[{
  "\nWe color each point ",
  Cell[BoxData[
      \(z\_0\)]],
  "  in the rectangle  ",
  Cell[BoxData[
      \(R = {z = 
            x + \(\[ImaginaryI]y : \(-2\) \[LessEqual] x \[LessEqual] 
                  2\), \(-2\) \[LessEqual] x \[LessEqual] 2}\)]],
  " in the following fashion.  Color the point yellow, blue, or red, if the \
sequence of iterations produced by the seed  ",
  Cell[BoxData[
      \(z\_0\)]],
  "  converges to ",
  Cell[BoxData[
      \(\(-1\), 1\/2 + \(\[ImaginaryI]\ \@3\)\/2, 
      1\/2 - \(\[ImaginaryI]\ \@3\)\/2\)]],
  ", respectively.  The iteration formula is "
}], "Text"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(g[z_] = 
        Together[z - f[z]\/\(f'\)[z]];\)\), "\[IndentingNewLine]", 
    \(\(\(Print["\<g[z] = \>", g[z]];\)\(\[IndentingNewLine]\)
    \)\)}], "Input"],

Cell[TextData[{
  "\nThe formulas for  f[z] and  g[z]  and approximations to the roots ",
  Cell[BoxData[
      \(z = \(-1\), 1\/2 + \(\[ImaginaryI]\ \@3\)\/2, 
      and\ 1\/2 - \(\[ImaginaryI]\ \@3\)\/2\)]],
  " are used in the function  newton[x,y]  to make the density plot."
}], "Text"],

Cell["\<\
newt = Compile[ {x, {n, _Integer}},
        Module[{t}, t = x; Do[t = (t + x/t)/2, {n}]; t]
       ]\
\>", "Input",
  CellTags->"S2.5.14"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(newton = \n
        Compile[{x, y}, \[IndentingNewLine]Module[{z, ct = 0}, 
            z = x + \[ImaginaryI]\ y; \[IndentingNewLine]While[
              Abs[Evaluate[z\^3 + 1]] > 0.001\  && \ 
                ct \[LessEqual] 
                  50, \[IndentingNewLine]z = \(\(-1\) + 2\ z\^3\)\/\(3\ \
z\^2\); \(++ct\)]; \[IndentingNewLine]Which[\[IndentingNewLine]Abs[
                  z - \((\(-1\))\)] < 0.1, 
              0.15, \[IndentingNewLine]Abs[
                  z - \((0.5\[InvisibleSpace] + 0.866\ \[ImaginaryI])\)] < 
                0.1, 0.5, \[IndentingNewLine]Abs[
                  z - \((0.5\[InvisibleSpace] - 0.866\ \[ImaginaryI])\)] < 
                0.1, 0.9]]\ ];\)\(\[IndentingNewLine]\)
    \)\)\)], "Input"],

Cell[TextData[{
  "\nMake a plot showing the initial seeds  ",
  Cell[BoxData[
      \(z\_0\)]],
  ",  and the nature of the sequence ",
  Cell[BoxData[
      \({z\_k}\)]],
  "  that is produced by it."
}], "Text"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(DensityPlot[
        newton[x, y], \[IndentingNewLine]{x, \(-2\), 2. }, \ {y, \(-2\), 
          2}, \[IndentingNewLine]PlotPoints \[Rule] 1000, Mesh \[Rule] False, 
        AspectRatio \[Rule] 1, \[IndentingNewLine]ColorFunction \[Rule] 
          Hue];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<Yellow points converge to  -1.\>"];\)\), \
"\[IndentingNewLine]", 
    \(\(Print[\*"\"\<Blue points converge to  \!\(1\/2\)+\!\(\(\[ImaginaryI] \
\@ 3\)\/2\).\>\""];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<Red  points converge to  \!\(1\/2\)-\!\(\(\[ImaginaryI] \
\@ 3\)\/2\).\>\""];\)\), "\[IndentingNewLine]", 
    \(\)}], "Input"],

Cell["\<\
This creates a compiled version of aMathematicaprogram which implements \
Newton's approximation to square roots.\
\>", "Text"],

Cell["\<\
newt = Compile[ {x, {n, _Integer}},
        Module[{t}, t = x; Do[t = (t + x/t)/2, {n}]; t]
       ]\
\>", "Input",
  CellTags->"S2.5.14"],

Cell[TextData[{
  "\n\tIn 1918 the French mathematicians Gaston Julia and Pierre Fatou \
noticed the fractal phenomenon when exploring iterations of functions not \
necessarily connected with Newton's method.  Beginning with a function  f(z)  \
and a point  ",
  Cell[BoxData[
      \(z\_0\)]],
  ",  they computed the iterates  ",
  Cell[BoxData[
      \(z\_1 = f \((z\_0)\)\)]],
  ", ",
  Cell[BoxData[
      \(z\_2 = f \((z\_1)\)\)]],
  ", ... , ",
  Cell[BoxData[
      \(z\_\(k + 1\) = f \((z\_k)\)\)]],
  ", and investigated properties of the sequences  ",
  Cell[BoxData[
      \({z\_k}\)]],
  ".  Their findings did not receive a great deal of attention, largely \
because computer graphics were not available at this time.  With the recent \
proliferation of computers, it is not surprising that these investigations \
were revived in the 1980's.  Detailed studies of Newton's method and the more \
general topic of iteration were undertaken by a host of mathematicians \
including Curry, Douady, Garnett, Hubbard, Mandlebrot, Milnor and Sullivan.  \
We now turn our attention to some of their results by focusing on the \
iterates produced by quadratics of the form   ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\) = z\^2 + c\)]],
  ".  "
}], "Text"],

Cell[TextData[{
  "\n",
  StyleBox["Example 4.22,  Page 119.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  Given  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\) = z\^2 + c\)]],
  ",  analyze all possible iterations for the function  ",
  Cell[BoxData[
      \(\(f\_0\) \((z)\) = z\^2 + 0\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Solution 4.22.",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]]], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "In the exercises we will ask you to verify that if  ",
  Cell[BoxData[
      \(\(\(|\)\(z\_0\)\(|\)\(\(<\)\(\ \)\(1\)\)\)\)]],
  "  the sequence will converge to  0,  i",
  "f  ",
  Cell[BoxData[
      \(\(\(|\)\(z\_0\)\(|\)\(\(>\)\(\ \)\(1\)\)\)\)]],
  "  the sequence will be unbounded, and if",
  "  ",
  Cell[BoxData[
      \(\(\(|\)\(z\_0\)\(|\)\) = \ 1\)]],
  "  the sequence will either oscillate chaotically around the unit circle or \
converge to  1."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "\n\tGiven the function  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\) = z\^2 + c\)]],
  ",  and an initial seed  ",
  Cell[BoxData[
      \(z\_0\)]],
  ",  the set of iterates given by  ",
  Cell[BoxData[
      \(z\_1 = \(f\_c\) \((z\_0)\)\)]],
  ", ",
  Cell[BoxData[
      \(z\_2 = \(f\_c\) \((z\_1)\)\)]],
  ", etc., are also called the ",
  StyleBox["orbits",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  " of  ",
  Cell[BoxData[
      \(z\_0\)]],
  "  generated by  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\)\)]],
  ".  Let  ",
  Cell[BoxData[
      \(K\_c\)]],
  "  denote the set of points with bounded orbits for  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\)\)]],
  ".  Example 4.22 shows that  ",
  Cell[BoxData[
      \(K\_0\)]],
  "  is the closed unit disk ",
  Cell[BoxData[
      \(\(\(D\_1\)\&_\) \((0)\)\)]],
  ".  The boundary of  ",
  Cell[BoxData[
      \(K\_c\)]],
  "  is known as the ",
  StyleBox["Julia set",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  " for the function  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\)\)]],
  ".  The Julia set for  ",
  Cell[BoxData[
      \(\(f\_0\) \((z)\)\)]],
  "  is the unit circle  ",
  Cell[BoxData[
      \(\(C\_1\) \((0)\)\)]],
  ".  It turns out that  ",
  Cell[BoxData[
      \(K\_c\)]],
  "  is a nice simple set only when  ",
  Cell[BoxData[
      \(c = \(0\ \ or\ \ c = \(-2\)\)\)]],
  ".  Otherwise,   ",
  Cell[BoxData[
      \(K\_c\)]],
  "  is fractal.  \n\n\tJulia and Fatou independently discovered a simple \
criterion that can be used to tell when the Julia set for  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\)\)]],
  "  is connected or disconnected.  We state their result, but omit the \
proof, as it is beyond the scope of this text."
}], "Text"],

Cell[TextData[{
  StyleBox["Theorem 4.14, Page 120.",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "  The boundary of  ",
  Cell[BoxData[
      \(K\_c\)]],
  "  is connected if and only if  ",
  Cell[BoxData[
      \(0  \[Epsilon]\ K\_c\)]],
  ".  In other words, the Julia set for  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\)\)]],
  "  is connected if and only if the orbits of  0  are bounded."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "\n",
  StyleBox["Example 4.23,  Page 120.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  Show that the Julia set for  ",
  Cell[BoxData[
      \(\(f\_\[ImaginaryI]\) \((z)\) = z\^2 + \[ImaginaryI]\)]],
  "  is connected."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Solution 4.23.",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]]], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "We apply Theorem 4.14 and compute the orbits of  0  for  ",
  Cell[BoxData[
      \(\(f\_\[ImaginaryI]\) \((z)\) = z\^2 + \[ImaginaryI]\)]],
  ".  "
}], "Text"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(Remove[z, Z];\)\), "\[IndentingNewLine]", 
    \(\(Clear[f, i];\)\), "\[IndentingNewLine]", 
    \(\(f[z_] = z\^2 + \[ImaginaryI];\)\), "\[IndentingNewLine]", 
    \(\(Z = NestList[f, 0, 7];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<f[z] = \>", f[z]];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<\>"];\)\), "\[IndentingNewLine]", 
    \(\(\(For[i = 0, 
        i \[LessEqual] 
          6, \(i++\), \[IndentingNewLine]\(Print["\<f[\>", 
            Z\_\(\(\[LeftDoubleBracket]\)\(i + 1\)\(\[RightDoubleBracket]\)\)\
\ , "\<] = \>", 
            Z\_\(\(\[LeftDoubleBracket]\)\(i + \
2\)\(\[RightDoubleBracket]\)\)];\)\ ];\)\(\[IndentingNewLine]\)
    \)\)}], "Input"],

Cell[TextData[{
  "\nThus, the orbits of  0  is the sequence  ",
  Cell[BoxData[
      \({0, \[ImaginaryI], \(-1\) + \[ImaginaryI], \(-\[ImaginaryI]\), \(-1\) \
+ \[ImaginaryI], \(-\[ImaginaryI]\), \(-1\) + \[ImaginaryI], \(-\[ImaginaryI]\
\),  ... }\)]],
  "  which is clearly a bounded sequence.  Thus, by Theorem 4.14, the Julia \
set for  ",
  Cell[BoxData[
      \(\(f\_\[ImaginaryI]\) \((z)\)\)]],
  "  is connected."
}], "Text"],

Cell[TextData[{
  "\n",
  StyleBox["Extra Example for  Page 120.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  " Plot the Julia set."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Extra Solution for Page 120.",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]]], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Here is the subroutine from the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  Journal."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(juliaC\  = \n
        Compile[{x, y, lim, cx, cy}, \[IndentingNewLine]Module[{z, ct = 0}, 
            z = x + \[ImaginaryI]\ y; \[IndentingNewLine]While[
              Abs[z] < 2.0\  && \ ct \[LessEqual] lim, \[IndentingNewLine]z = 
                z\^2 + \((cx + \[ImaginaryI]\ cy)\); \(++ct\)]; 
            ct]\ ];\)\(\[IndentingNewLine]\)
    \)\)\)], "Input"],

Cell[TextData[{
  "Here is the Julia set generated by the value  c = -1.25.  This is a fuzzy \
picture of Color Plate 4.  Increase the number of PlotPoints to get a sharper \
picture.  Also, it will increase the computing time.  It takes quite a bit of \
time with  ",
  Cell[BoxData[
      \(PlotPoints \[Rule] 200\)]],
  ".  Things start to look better with  ",
  Cell[BoxData[
      \(PlotPoints \[Rule] 500\)]],
  ".  "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\[IndentingNewLine]\(DensityPlot[\(-juliaC[x, y, 50, \(-1.25\), 
            0]\), \[IndentingNewLine]{x, \(-1.5\), 1.5}, \ {y, \(-1.0\), 
          1.0}, \[IndentingNewLine]PlotPoints \[Rule] 500, 
        Mesh \[Rule] False, 
        AspectRatio \[Rule] 2\/3, \[IndentingNewLine]ColorFunction \[Rule] 
          Hue];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<The Julia set generated by the value c = -1.25\>"];\)\), "\
\[IndentingNewLine]", 
    \(\)}], "Input",
  AspectRatioFixed->True],

Cell[TextData[{
  "\n\tIn 1980, the Polish born mathematician Benoit Mandelbrot used computer \
graphics to study the following set:  \n\n",
  Cell[BoxData[
      \(M = \({c : \ the\ Julia\ set\ for\ \(f\_c\) \((z)\)\ is\ connected}\n
        \ \ \(\(=\)\({c : \ 
              the\ orbits\ of\ \ 0\ \ determined\ by\ \(f\_c\) \((z)\)\ are\ \
bounded}\)\)\)\)]],
  "  \n\nThe set  M  has come to be known as the Mandelbrot set.  The \
remainder of this section looks at some of the properties of this amazing \
set."
}], "Text"],

Cell[TextData[{
  "\n",
  StyleBox["Example 4.24,  Page 121.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  Show that ",
  Cell[BoxData[
      \({c : \(\(|\)\(z\)\(|\)\(\(\[LessEqual]\)\(1\/4\)\)\)}\)]],
  " is a subset of the Mandelbrot set  M."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Solution 4.24.",
    FontColor->RGBColor[1, 0, 1]],
  "  See page 121 in the text."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell["\<\

\tThere are other methods for determining which points belong to  M.  To see \
what they are, we need some additional vocabulary.\
\>", "Text"],

Cell[TextData[{
  StyleBox["Definition 4.5, Page 121.",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "  The point  ",
  Cell[BoxData[
      \(z\_0\)]],
  "  is a fixed point for the function  f  if  ",
  Cell[BoxData[
      \(f \((z\_0)\) = z\_0\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Definition 4.6, Page 121.",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "  The point  ",
  Cell[BoxData[
      \(z\_0\)]],
  "  is an attracting point for the function  f  if  ",
  Cell[BoxData[
      \(\(\(|\)\(f' \((z\_0)\)\)\(|\)\(\(<\)\(\ \)\(1\)\)\)\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Theorem 4.15, Page 122.",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "  Suppose ",
  Cell[BoxData[
      \(z\_0\)]],
  "  is an attracting fixed point for the function  f.  Then there is a disk  \
",
  Cell[BoxData[
      \(\(D\_r\) \((z\_0)\)\)]],
  "  about  ",
  Cell[BoxData[
      \(z\_0\)]],
  "  such that the iterates of all the points in ",
  Cell[BoxData[
      \(\(D\_r\) \((z\_0)\)\)]],
  "  are dawn toward the point  ",
  Cell[BoxData[
      \(z\_0\)]],
  "  in the sense that if  ",
  Cell[BoxData[
      \(z \[Element] \(D\_r\%*\) \((z\_0)\)\)]],
  ", then  ",
  Cell[BoxData[
      \(\(\(|\)\(f \((z)\) - 
          z\_0\)\(|\)\(\(<\)\(\(|\)\(z - z\_0\)\(|\)\)\)\)\)]],
  "."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Proof of Theorem 4.15,  see text Page 122.",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 1, 1]]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "\n\tIn 1905, Fatou showed that if the function  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\)\)]],
  "  has attracting fixed points, the orbits of  0  determined by  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\)\)]],
  "  must converge to one of them.  Since a convergent sequence is bounded, \
this implies that  c  must belong to  M.  In the exercises we ask you to show \
that the main cardioid-shaped body of  M is composed of those points  c  for \
which  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\)\)]],
  "  has attracting fixed points.  You will find that Theorem 4.16 is a \
useful characterization of them.\n"
}], "Text"],

Cell[TextData[{
  StyleBox["Theorem 4.16, Page 122.",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "  The points  c  for which  ",
  Cell[BoxData[
      \(\(f\_c\) \((z)\)\)]],
  "  has attracting fixed points satisfy  ",
  Cell[BoxData[
      \(\(\(|\)\(1 + \((1 - 4  c)\)\^\(1/2\)\)\(|\)\(\(<\)\(\ \
\)\(1\)\)\)\)]],
  "  or  ",
  Cell[BoxData[
      \(\(\(|\)\(1 - \((1 - 4  c)\)\^\(1/2\)\)\(|\)\(\(<\)\(\ \
\)\(1\)\)\)\)]],
  ",  where the square root is the principal square root function."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Proof of Theorem 4.16,  see text Page 122.",
  FontWeight->"Bold",
  FontColor->RGBColor[0, 1, 1]]], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Definition 4.7, Page 123.",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "  An n-cycle for a function  f  is a set  ",
  Cell[BoxData[
      \({z\_0, z\_1,  ... , z\_\(n - 1\)}\)]],
  "  of  n  complex numbers such that  ",
  Cell[BoxData[
      \(z\_k = f \((z\_\(k - 1\))\)\)]],
  "  for  ",
  Cell[BoxData[
      \(k = 1, 2,  ... , n - 1\)]],
  ",  and  ",
  Cell[BoxData[
      \(f \((z\_\(n - 1\))\) = z\_0\)]],
  ".  "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  StyleBox["Definition 4.8, Page 123.",
    FontWeight->"Bold",
    FontColor->RGBColor[0, 0, 1]],
  "  An n-cycle  ",
  Cell[BoxData[
      \({z\_0, z\_1,  ... , z\_\(n - 1\)}\)]],
  "  for a function  f   is said to be attracting if  ",
  Cell[BoxData[
      \(\(\(|\)\(\(g\_n\%'\) \((z\_0)\)\)\(|\)\(\(<\)\(\ \)\(1\)\)\)\)]],
  ",  where  ",
  Cell[BoxData[
      \(g\_n\)]],
  "  is the composition of  f  with itself  n  times.  \nFor example, if n = \
2, then ",
  Cell[BoxData[
      \(\(g\_2\) \((z)\)\  = \ f \((f \((z)\))\)\)]],
  ". "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[{
  "\n",
  StyleBox["Example 4.25,  Page 123.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  "  Example 4.23 shows that  ",
  Cell[BoxData[
      \({\(-1\) + \[ImaginaryI], \(-\[ImaginaryI]\)}\)]],
  "  is a 2-cycle for the function  ",
  Cell[BoxData[
      \(\(f\_\[ImaginaryI]\) \((z)\) = z\^2 + \[ImaginaryI]\)]],
  ".  Show that it is not an attracting 2-cycle."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Solution 4.25.",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]]], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "Enter the function  ",
  Cell[BoxData[
      \(f[z] = z\^2 + \[ImaginaryI]\)]],
  "  and point  ",
  Cell[BoxData[
      \(z\_0 = \(-1\) + \[ImaginaryI]\)]],
  "  and determine if  ",
  Cell[BoxData[
      \(\(\(|\)\(\(g\_n\%'\) \((z\_0)\)\)\(|\)\(\(<\)\(\ \)\(1\)\)\)\)]],
  ".  "
}], "Text"],

Cell[BoxData[{
    \(\[IndentingNewLine]\(Remove[z, Z];\)\), "\[IndentingNewLine]", 
    \(\(Clear[f, g2];\)\), "\[IndentingNewLine]", 
    \(\(f[z_] = z\^2 + \[ImaginaryI];\)\), "\n", 
    \(\(g2[z_] = Apart[ComplexExpand[f[f[z]]]];\)\), "\[IndentingNewLine]", 
    \(\(Z\_0 = \(-1\) + \[ImaginaryI];\)\), "\n", 
    \(\(Print[\*"\"\<\!\(f\_\[ImaginaryI]\)[z] = \>\"", 
        f[z]];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<\>"];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<\!\(g\_2\)[z] = \>\"", 
        g2[z]];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<\>"];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<\!\(\(g\_2\%'\)\)[z] = \>\"", \(g2'\)[
          z]];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<\>"];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<\!\(\(g\_2\%'\)\)[\>\"", 
        Z\_0, "\<] = \>", \(g2'\)[Z\_0]];\)\), "\[IndentingNewLine]", 
    \(\(Print[\*"\"\<|\!\(\(g\_2\%'\)\)[\>\"", Z\_0, "\<]| = \>", 
        Abs[\(g2'\)[Z\_0]]];\)\), "\[IndentingNewLine]", 
    \(\(\(Print[\*"\"\<Is  |\!\(\(g\_2\%'\)\)[\>\"", Z\_0, "\<]| > 1 ?  \>", 
        Abs[\(g2'\)[Z\_0]] > 1];\)\(\[IndentingNewLine]\)
    \)\)}], "Input"],

Cell[TextData[{
  "\nTherefore,  ",
  Cell[BoxData[
      \({\(-1\) + \[ImaginaryI], \(-\[ImaginaryI]\)}\)]],
  "  is not an attracting 2-cycle."
}], "Text"],

Cell[TextData[{
  "\n",
  StyleBox["Extra Example for  Page 123.",
    FontWeight->"Bold",
    FontColor->RGBColor[1, 0, 0]],
  " Plot the Mandelbrot set."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[TextData[StyleBox["Extra Solution for Page 123.",
  FontWeight->"Bold",
  FontColor->RGBColor[1, 0, 1]]], "Text",
  Evaluatable->False,
  AspectRatioFixed->False],

Cell[TextData[{
  "This modification of the  juliaC  code can be used to plot the Mandelbrot \
set.\n\nHere is the subroutine from the ",
  StyleBox["Mathematica",
    FontSlant->"Italic"],
  "  Journal."
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(mandelbrotC = 
        Compile[{x, y, lim}, \[IndentingNewLine]Module[{z, ct = 0}, 
            z = x + \[ImaginaryI]\ y; \[IndentingNewLine]While[
              Abs[z] < 2.0\  && \ ct \[LessEqual] lim, \[IndentingNewLine]z = 
                z\^2 + \((x + \[ImaginaryI]\ y)\); \(++ct\)]; 
            ct]\ ];\)\(\[IndentingNewLine]\)
    \)\)\)], "Input"],

Cell[TextData[{
  "This is a fuzzy picture of Color Plate 6. Increase the number of \
PlotPoints to get a sharper picture.  Also, it will increase the computing \
time.  It takes quite a bit of time with  ",
  Cell[BoxData[
      \(PlotPoints \[Rule] 200\)]],
  ".  Things start to look better with  ",
  Cell[BoxData[
      \(PlotPoints \[Rule] 500\)]],
  ".  "
}], "Text",
  Evaluatable->False,
  AspectRatioFixed->True],

Cell[BoxData[{
    \(\[IndentingNewLine]\(DensityPlot[
        mandelbrotC[x, y, 50], \[IndentingNewLine]{x, \(-2.0\), 
          0.55}, \ {y, \(-1.15\), 
          1.15}, \[IndentingNewLine]PlotPoints \[Rule] 500, \ 
        Mesh \[Rule] False, \[IndentingNewLine]Frame \[Rule] False, 
        ColorFunction \[Rule] Hue];\)\), "\[IndentingNewLine]", 
    \(\(Print["\<The Mandelbrot set.\>"];\)\), "\[IndentingNewLine]", 
    \(\)}], "Input"]
},
FrontEndVersion->"4.1 for Microsoft Windows",
ScreenRectangle->{{0, 800}, {0, 527}},
AutoGeneratedPackage->Automatic,
WindowSize->{792, 500},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{
  "S2.5.14"->{
    Cell[20409, 623, 148, 5, 66, "Input",
      CellTags->"S2.5.14"],
    Cell[22394, 675, 148, 5, 66, "Input",
      CellTags->"S2.5.14"]}
  }
*)

(*CellTagsIndex
CellTagsIndex->{
  {"S2.5.14", 41202, 1290}
  }
*)

(*NotebookFileOutline
Notebook[{
Cell[1705, 50, 81, 2, 30, "Input"],
Cell[1789, 54, 145, 3, 30, "Input"],
Cell[1937, 59, 126, 2, 30, "Input"],
Cell[2066, 63, 565, 20, 74, "Text",
  Evaluatable->False],
Cell[2634, 85, 153, 4, 33, "Text",
  Evaluatable->False],
Cell[2790, 91, 169, 6, 33, "Text"],
Cell[2962, 99, 802, 20, 227, "Input"],
Cell[3767, 121, 501, 17, 95, "Text",
  Evaluatable->False],
Cell[4271, 140, 664, 17, 207, "Input"],
Cell[4938, 159, 475, 16, 95, "Text",
  Evaluatable->False],
Cell[5416, 177, 444, 8, 178, "Input"],
Cell[5863, 187, 187, 7, 52, "Text",
  Evaluatable->False],
Cell[6053, 196, 501, 10, 210, "Input"],
Cell[6557, 208, 130, 5, 52, "Text",
  Evaluatable->False],
Cell[6690, 215, 1320, 27, 324, "Input"],
Cell[8013, 244, 223, 7, 55, "Text"],
Cell[8239, 253, 1581, 35, 480, "Input"],
Cell[9823, 290, 283, 6, 70, "Input"],
Cell[10109, 298, 76, 1, 30, "Input"],
Cell[10188, 301, 110, 2, 31, "Input"],
Cell[10301, 305, 777, 31, 30, "Input"],
Cell[11081, 338, 70, 1, 30, "Input"],
Cell[11154, 341, 174, 4, 30, "Input"],
Cell[11331, 347, 170, 4, 30, "Input"],
Cell[11504, 353, 83, 1, 30, "Input"],
Cell[11590, 356, 153, 3, 30, "Input"],
Cell[11746, 361, 66, 1, 30, "Input"],
Cell[11815, 364, 148, 2, 30, "Input"],
Cell[11966, 368, 186, 4, 30, "Input"],
Cell[12155, 374, 369, 8, 90, "Input"],
Cell[12527, 384, 50, 1, 30, "Input"],
Cell[12580, 387, 342, 7, 90, "Input"],
Cell[12925, 396, 58, 1, 30, "Input"],
Cell[12986, 399, 2214, 61, 235, "Text"],
Cell[15203, 462, 167, 7, 33, "Text",
  Evaluatable->False],
Cell[15373, 471, 121, 3, 30, "Input",
  InitializationCell->True],
Cell[15497, 476, 475, 18, 74, "Text",
  Evaluatable->False],
Cell[15975, 496, 147, 3, 30, "Input"],
Cell[16125, 501, 181, 4, 50, "Input"],
Cell[16309, 507, 392, 6, 106, "Input"],
Cell[16704, 515, 121, 3, 33, "Text"],
Cell[16828, 520, 588, 21, 80, "Text",
  Evaluatable->False],
Cell[17419, 543, 167, 4, 33, "Text",
  Evaluatable->False],
Cell[17589, 549, 124, 5, 33, "Text"],
Cell[17716, 556, 1563, 31, 350, "Input"],
Cell[19282, 589, 625, 18, 80, "Text"],
Cell[19910, 609, 202, 4, 106, "Input"],
Cell[20115, 615, 291, 6, 80, "Text"],
Cell[20409, 623, 148, 5, 66, "Input",
  CellTags->"S2.5.14"],
Cell[20560, 630, 785, 14, 251, "Input"],
Cell[21348, 646, 214, 8, 52, "Text"],
Cell[21565, 656, 686, 12, 232, "Input"],
Cell[22254, 670, 137, 3, 33, "Text"],
Cell[22394, 675, 148, 5, 66, "Input",
  CellTags->"S2.5.14"],
Cell[22545, 682, 1257, 30, 166, "Text"],
Cell[23805, 714, 375, 14, 52, "Text",
  Evaluatable->False],
Cell[24183, 730, 153, 4, 33, "Text",
  Evaluatable->False],
Cell[24339, 736, 540, 16, 52, "Text",
  Evaluatable->False],
Cell[24882, 754, 1778, 66, 166, "Text"],
Cell[26663, 822, 472, 16, 52, "Text",
  Evaluatable->False],
Cell[27138, 840, 319, 11, 52, "Text",
  Evaluatable->False],
Cell[27460, 853, 153, 4, 33, "Text",
  Evaluatable->False],
Cell[27616, 859, 179, 5, 33, "Text"],
Cell[27798, 866, 714, 14, 210, "Input"],
Cell[28515, 882, 435, 11, 71, "Text"],
Cell[28953, 895, 210, 8, 52, "Text",
  Evaluatable->False],
Cell[29166, 905, 167, 4, 33, "Text",
  Evaluatable->False],
Cell[29336, 911, 180, 7, 33, "Text",
  Evaluatable->False],
Cell[29519, 920, 414, 7, 154, "Input"],
Cell[29936, 929, 483, 13, 71, "Text",
  Evaluatable->False],
Cell[30422, 944, 516, 10, 166, "Input"],
Cell[30941, 956, 528, 11, 145, "Text"],
Cell[31472, 969, 325, 11, 55, "Text",
  Evaluatable->False],
Cell[31800, 982, 172, 6, 33, "Text",
  Evaluatable->False],
Cell[31975, 990, 154, 4, 52, "Text"],
Cell[32132, 996, 332, 13, 33, "Text",
  Evaluatable->False],
Cell[32467, 1011, 370, 13, 33, "Text",
  Evaluatable->False],
Cell[32840, 1026, 798, 30, 52, "Text",
  Evaluatable->False],
Cell[33641, 1058, 180, 4, 33, "Text",
  Evaluatable->False],
Cell[33824, 1064, 646, 15, 128, "Text"],
Cell[34473, 1081, 571, 18, 52, "Text",
  Evaluatable->False],
Cell[35047, 1101, 180, 4, 33, "Text",
  Evaluatable->False],
Cell[35230, 1107, 528, 19, 52, "Text",
  Evaluatable->False],
Cell[35761, 1128, 621, 20, 71, "Text",
  Evaluatable->False],
Cell[36385, 1150, 458, 14, 71, "Text",
  Evaluatable->False],
Cell[36846, 1166, 153, 4, 33, "Text",
  Evaluatable->False],
Cell[37002, 1172, 312, 11, 33, "Text"],
Cell[37317, 1185, 1164, 21, 334, "Input"],
Cell[38484, 1208, 157, 5, 52, "Text"],
Cell[38644, 1215, 215, 8, 52, "Text",
  Evaluatable->False],
Cell[38862, 1225, 167, 4, 33, "Text",
  Evaluatable->False],
Cell[39032, 1231, 264, 8, 71, "Text",
  Evaluatable->False],
Cell[39299, 1241, 405, 7, 134, "Input"],
Cell[39707, 1250, 422, 12, 52, "Text",
  Evaluatable->False],
Cell[40132, 1264, 443, 8, 150, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

